// Copyright (c) Microsoft Corporation. All rights reserved.
// Script for ATL Simple Object

function OnPrep(selProj, selObj)
{
	var L_WizardDialogTitle_Text = "ATL 򵥶";
	return PrepCodeWizard(selProj, L_WizardDialogTitle_Text);
}

function OnFinish(selProj, selObj)
{
	var oCM;
	try
	{
		oCM	= selProj.CodeModel;
		var bDevice = IsDeviceProject(selProj);
		wizard.AddSymbol("DEVICE", bDevice);
		AddDeviceSymbols(false);

		var strShortName = wizard.FindSymbol("SHORT_NAME");
		var L_TRANSACTION_Text = " ATL 򵥶 ";
		oCM.StartTransaction(L_TRANSACTION_Text + strShortName);
		if(!AddATLSupportToProject(selProj))
		{
			oCM.AbortTransaction();
			return;
		}

		var bDLL;
		if (typeDynamicLibrary == selProj.Object.Configurations(1).ConfigurationType)
			bDLL = true;
		else
			bDLL = false;
		wizard.AddSymbol("DLL_APP", bDLL);
		
		// used only for device projects where platforms may not support DCOM.
		wizard.AddSymbol("SUPPORT_DCOM", false);
		wizard.AddSymbol("SUPPORT_NON_DCOM", false);

		var isMFCProject = IsMFCProject(selProj, false);
		wizard.AddSymbol("MFC_SUPPORT", isMFCProject);


		var strProjectName		= wizard.FindSymbol("SAFE_PROJECT_IDENTIFIER_NAME");
		var strProjectPath		= wizard.FindSymbol("PROJECT_PATH");
		var strTemplatePath		= wizard.FindSymbol("TEMPLATES_PATH");
		var strUpperShortName		= CreateASCIIName(strShortName.toUpperCase());
		var strInterfaceName		= wizard.FindSymbol("INTERFACE_NAME");
		var strProjectIdlName   	= strProjectName + ".idl";
		
		wizard.AddSymbol("UPPER_SHORT_NAME", strUpperShortName);
		var strVIProgID			= wizard.FindSymbol("VERSION_INDEPENDENT_PROGID");
		if (strVIProgID == null || strVIProgID == "")
		{
			wizard.AddSymbol("PROGID_VALID", false);
			wizard.AddSymbol("VERSION_INDEPENDENT_PROGID","");
			wizard.AddSymbol("PROGID","");
		}
		else
		{
			wizard.AddSymbol("PROGID_VALID", true);
			wizard.AddSymbol("PROGID", strVIProgID.substr(0,37) + ".1");
		}
		var bConnectionPoint		= wizard.FindSymbol("CONNECTION_POINTS");
 		var strClassName		= wizard.FindSymbol("CLASS_NAME");
		var strHeaderFile		= wizard.FindSymbol("HEADER_FILE");
		var strImplFile			= wizard.FindSymbol("IMPL_FILE");
		var strCoClass			= wizard.FindSymbol("COCLASS");
		var bAttributed			= wizard.FindSymbol("ATTRIBUTED");

		var strProjectRC		= GetProjectFile(selProj, "RC", true, false);

		// Create necessary GUIDS
		CreateGUIDs();

		if (!bAttributed)
		{
			var MidlTool = GetIDLConfig(selProj,true);
			var strMidlHeader = MidlTool.HeaderFileName;
			strMidlHeader = selProj.Object.Configurations(1).Evaluate(strMidlHeader);
			wizard.AddSymbol("MIDL_H_FILENAME",strMidlHeader);

			// Get LibName
			wizard.AddSymbol("LIB_NAME", oCM.IDLLibraries(1).Name);

			// Get LibID
			var oUuid = oCM.IDLLibraries(1).Attributes.Find("uuid");
			if (oUuid)
				wizard.AddSymbol("LIBID_REGISTRY_FORMAT", oUuid.Value);

			// Get typelib version
			var oVersion = oCM.IDLLibraries(1).Attributes.Find("version");
			if (oVersion)
			{
				var aryMajorMinor = oVersion.Value.split('.');
				for (var nCntr=0; nCntr<aryMajorMinor.length; nCntr++)
				{
					if (nCntr == 0)
						wizard.AddSymbol("TYPELIB_VERSION_MAJOR", aryMajorMinor[nCntr]);
					else
						wizard.AddSymbol("TYPELIB_VERSION_MINOR", aryMajorMinor[nCntr]);
				}
			}

			// Get AppID
			var strAppID = wizard.GetAppID();
			if (strAppID.length > 0)
			{
				wizard.AddSymbol("APPID_EXIST", true);
				wizard.AddSymbol("APPID_REGISTRY_FORMAT", strAppID);
			}

			// add RGS file resource
			var strRGSFile = GetUniqueFileName(strProjectPath, CreateASCIIName(strShortName) + ".rgs");
			var strRGSDCOMFile = GetUniqueFileName(strProjectPath, CreateASCIIName(strShortName + "DCOM") + ".rgs");
			var strRGSID = "IDR_" + strUpperShortName;
			var strRGSDCOMID = "IDR_" + strUpperShortName + "DCOM";

			var bDeviceDCOM = ProjectContainsDCOMPlatform(selProj)
			var bDeviceNonDCOM = ProjectContainsNonDCOMPlatform(selProj)
			
			if (!bDevice)
			{
				RenderAddTemplate(wizard, "object.rgs", strRGSFile, false, false);
			}
			else
			{
				if (bDeviceDCOM)
				{
					wizard.AddSymbol("SUPPORT_DCOM", true);
					RenderAddTemplate(wizard, "object.rgs", strRGSDCOMFile, false, false);
					wizard.AddSymbol("SUPPORT_DCOM", false);
				}
				if (bDeviceNonDCOM)
				{
					wizard.AddSymbol("SUPPORT_NON_DCOM", true);
					RenderAddTemplate(wizard, "object.rgs", strRGSFile, false, false);
					wizard.AddSymbol("SUPPORT_NON_DCOM", false);
				} 
			}    

			wizard.AddSymbol("SUPPORT_DCOM", bDeviceDCOM);
			wizard.AddSymbol("SUPPORT_NON_DCOM", bDeviceNonDCOM);

			if (!bDevice)
			{
				var oResHelper = wizard.ResourceHelper;
				oResHelper.OpenResourceFile(strProjectRC);

				var strSymbolValue = oResHelper.AddResource(strRGSID, strProjectPath + strRGSFile, "REGISTRY");
				if (strSymbolValue == null) return;				
				wizard.AddSymbol("RGS_ID", strSymbolValue.split("=").shift());

				oResHelper.CloseResourceFile();
			}
			else
			{
				var completedResourceFiles = new Array();
				var configs = selProj.Object.Configurations;
				AddDeviceSymbols(false);

				var oResHelper = wizard.ResourceHelper;

				for (var nCntr = 1; nCntr <= configs.Count; nCntr++)
				{
					var config = configs.Item(nCntr);
					var strCurrentResource = GetDeviceResourceFileForConfig(config);
					
					if (completedResourceFiles.join(";").indexOf(strCurrentResource) == -1)
					{
						oResHelper.OpenResourceFile(strCurrentResource);
						if (bDeviceNonDCOM)
						{
							var strSymbolValue = oResHelper.AddResource(strRGSID, strProjectPath + strRGSFile, "REGISTRY");
							if (strSymbolValue == null) return;				
							wizard.AddSymbol("RGS_ID", strSymbolValue.split("=").shift());
						}
						if (bDeviceDCOM)
						{
							var strSymbolValue = oResHelper.AddResource(strRGSDCOMID, strProjectPath + strRGSDCOMFile, "REGISTRY");
							if (strSymbolValue == null) return;
							wizard.AddSymbol("RGSDCOM_ID", strSymbolValue.split("=").shift());
						}
						oResHelper.CloseResourceFile();
						completedResourceFiles.push(strCurrentResource);
					}
					
				}
			}

			// Add connection point support
			if (bConnectionPoint)
				RenderAddTemplate(wizard, "connpt.h", "_" + strInterfaceName + "Events_CP.h", selObj, false);

			// Render objco.idl and insert into strProject.idl
			AddCoclassFromFile(oCM, "objco.idl");

			// Render objint.idl and insert into strProject.idl
			AddInterfaceFromFile(oCM, "objint.idl");
			
			// Add required import statements
			AddImportStatements(oCM, selProj, strProjectIdlName);
			
			// Add (generate) ATL-based document definition and implementation if required, 
			// Add #define SHARED_HANDLERS to stdafx.h
			if (wizard.FindSymbol("ADD_HANDLER_SUPPORT"))
			{
				if (wizard.FindSymbol("HANDLER_GEN_ATL_DOC"))
				{
					var strAtlDocHeader = wizard.FindSymbol("HANDLER_ATL_DOC_HEADER_FILE_TRIMMED");
					var strAtlDocImpl = wizard.FindSymbol("HANDLER_ATL_DOC_IMPL_FILE_TRIMMED");

					// Add header
					RenderAddTemplate(wizard, "document.h", strAtlDocHeader, selObj, false);

					// Add CPP
					RenderAddTemplate(wizard, "document.cpp", strAtlDocImpl, selObj, false);
				}
				else if (wizard.FindSymbol("HANDLER_ATL_DOC_CLASS_NAME_SPECIFIED"))
				{
					// user specifies ATL-based doc class name only
					var strAtlDocName = wizard.FindSymbol("HANDLER_ATL_DOC_CLASS_NAME_TRIMMED");
					var elem = oCM.Classes.Find(strAtlDocName);

					// add #include if the class is defined
					if (elem != null)
					{
						var strAtlDocNameFromCM = elem.File.substr(elem.File.lastIndexOf("\\") + 1);
					}
				}
				else
				{
					// Add existing items (links) from MFC project handlers are being added for.
					// Add the document h/cpp, view h.cpp, and cntritem h/cpp (if exist).
					var strMFCDocHeader = wizard.FindSymbol("HANDLER_DOCUMENT_FILE_NAME_TRIMMED");
					if (strMFCDocHeader != "")
					{
						if (selProj.Object.CanAddFile(strMFCDocHeader))
						{
							selProj.Object.AddFile(strMFCDocHeader);
						}

						var strMFCDocImpl = strMFCDocHeader.substring(0, strMFCDocHeader.length - 1) + "cpp";
						if (selProj.Object.CanAddFile(strMFCDocImpl))
						{
							selProj.Object.AddFile(strMFCDocImpl);
						}

						var strMFCViewHeader = wizard.FindSymbol("HANDLER_VIEW_FILE_NAME_TRIMMED");
						if (strMFCViewHeader != "")
						{
							if (selProj.Object.CanAddFile(strMFCViewHeader))
							{
								selProj.Object.AddFile(strMFCViewHeader);
							}

							var strMFCViewImpl = strMFCViewHeader.substring(0, strMFCViewHeader.length - 1) + "cpp";
							if (selProj.Object.CanAddFile(strMFCViewImpl))
							{
								selProj.Object.AddFile(strMFCViewImpl);
							}
						}

						var nLength = strMFCDocHeader.length;
						var nEndIndex = nLength - 1;
						while (nEndIndex > 0 && (strMFCDocHeader.charAt(nEndIndex) != '\\'))
						{
							nEndIndex--;
						}

						var strMFCCntrHeader = strMFCDocHeader.substring(0, nEndIndex + 1) + "CntrItem.h";
						if (selProj.Object.CanAddFile(strMFCCntrHeader))
						{
							selProj.Object.AddFile(strMFCCntrHeader);
						}

						var strMFCCntrImpl = strMFCDocHeader.substring(0, nEndIndex + 1) + "CntrItem.cpp";
						if (selProj.Object.CanAddFile(strMFCCntrImpl))
						{
							selProj.Object.AddFile(strMFCCntrImpl);
						}
					}
				}

				AddDefineSharedHandlersStatement(oCM);
			}

			SetMergeProxySymbol(selProj);
		}

		// Add header
		RenderAddTemplate(wizard, "object.h", strHeaderFile, selObj, true);

		// Add CPP
		RenderAddTemplate(wizard, "object.cpp", strImplFile, selObj, false);

		oCM.CommitTransaction();
				
		var newClass = oCM.Classes.Find(strClassName);
		if(newClass)
			newClass.StartPoint.TryToShow(vsPaneShowTop);		
	}
	catch(e)
	{
		if (oCM)
			oCM.AbortTransaction();

		if (e.description.length != 0)
			SetErrorInfo(e);
		return e.number
	}
}

function CreateGUIDs()
{
	try
	{
		// create CLSID
		var strRawGUID = wizard.CreateGuid();
		var strFormattedGUID = wizard.FormatGuid(strRawGUID, 0);
		wizard.AddSymbol("CLSID_REGISTRY_FORMAT", strFormattedGUID);

		// create interface GUID
		strRawGUID = wizard.CreateGuid();
		strFormattedGUID = wizard.FormatGuid(strRawGUID, 0);
		wizard.AddSymbol("INTERFACE_IID", strFormattedGUID);
		
		// create GUID for Search Persistent Handler registration (used in rgs)
		var bSearchHandler = wizard.FindSymbol("SEARCH_HANDLER");
		if (bSearchHandler)
		{
		    strRawGUID = wizard.CreateGuid();
		    strFormattedGUID = wizard.FormatGuid(strRawGUID, 0);
		    wizard.AddSymbol("CLSID_PERSISTENT_HANDLER", strFormattedGUID);
		}

		// create connection point GUID
		var bConnectionPoint = wizard.FindSymbol("CONNECTION_POINTS");
		if (bConnectionPoint)
		{
			strRawGUID = wizard.CreateGuid();
			strFormattedGUID = wizard.FormatGuid(strRawGUID, 0);
			wizard.AddSymbol("CONNECTION_POINT_IID", strFormattedGUID);
		}
	}
	catch(e)
	{
		throw e;
	}
}

function AddImportStatements(oCM, selProj, strProjectIdlName)
{
    var vcIDLImport;
    
	var bSearchHandler = wizard.FindSymbol("SEARCH_HANDLER");
	if (bSearchHandler)
	{
	    var i = 0;
        for (i = 1; i <= oCM.IDLImports.Count; i++)
        {
            vcIDLImport = oCM.IDLImports.Item(i);
            if (vcIDLImport.Name == "filter.idl")
            {
                return;
            }
        }
        
        oCM.AddIDLImport("\"filter.idl\"", strProjectIdlName, -1);
	}
	
    var bThumbnailProvider = wizard.FindSymbol("THUMBNAIL_PROVIDER_HANDLER");
    if (bThumbnailProvider)
    {
        var i = 0;
        for (i = 1; i <= oCM.IDLImports.Count; i++)
        {
            vcIDLImport = oCM.IDLImports.Item(i);
            if (vcIDLImport.Name == "thumbcache.idl")
            {
                return;
            }
        }
        
        oCM.AddIDLImport("\"thumbcache.idl\"", strProjectIdlName, -1);
    }
    
    var bRichPreviewHandler = wizard.FindSymbol("PREVIEW_HANDLER");
    if (bRichPreviewHandler)
    {
        var i = 0;
        for (i = 1; i <= oCM.IDLImports.Count; i++)
        {
            vcIDLImport = oCM.IDLImports.Item(i);
            if (vcIDLImport.Name == "shobjidl.idl")
            {
                return;
            }
        }
        
        oCM.AddIDLImport("\"shobjidl.idl\"", strProjectIdlName, -1);
    }
}
function AddDefineSharedHandlersStatement(oCM)
{
    if(oCM.Macros.Find("SHARED_HANDLERS") == null)
    {
        oCM.AddMacro("SHARED_HANDLERS", "stdafx.h", "", -1);
    }
}

// SIG // Begin signature block
// SIG // MIIkRwYJKoZIhvcNAQcCoIIkODCCJDQCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // EQVx+QDBKAlbA4YvAjaKTZtKdhvFzzsXIpgukW3W+l2g
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFgwwghYIAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggfcwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIOB+Pv4CpLVVo+LW8ori3GRp8NQ5UhiBu5uR0o8E
// SIG // 4i/KMIGKBgorBgEEAYI3AgEMMXwweqBggF4AZABlAGYA
// SIG // YQB1AGwAdABfAGEANwA4ADEANAA1AGEAZQAtAGUAMwAw
// SIG // AGIALQA0AGIAMwA0AC0AOAAzADgAOQAtADIAZAA0ADIA
// SIG // MgBjADMAOAA5ADQAZgAxAC4AagBzoRaAFGh0dHA6Ly9t
// SIG // aWNyb3NvZnQuY29tMA0GCSqGSIb3DQEBAQUABIIBALr2
// SIG // 7CQTvzuCa9Q2+dlbfzciKKntIUJaTjHfU7msnJWgmGb+
// SIG // t1mVx9h5SFAoXbjTXiTx5l2QBdSmab7rfs6RbJ0cucue
// SIG // 4DI1n4Qjr+Q2+KyAqIw3q20fofz0DT+LrnI9+Tnq1fl8
// SIG // Q1JPmpr9MaZjeJetFZGW5TiiisIFYu4CXuktJBBhBpLQ
// SIG // gj0XJc11str+pZmtyt79ny50+gkAlMwfHpRVMosWfkTQ
// SIG // zgLFP5KDdjPTp/Jnd7SPSrVuNVdVr7QhJiT/wFdwtsST
// SIG // vl9M4LkpIOgzWDi8VGpXjPXHf/0+T/45IlaH1T6ONPkL
// SIG // 4qqnNkohT9qV4w4noVm9OQQV1xac8dihghNNMIITSQYK
// SIG // KwYBBAGCNwMDATGCEzkwghM1BgkqhkiG9w0BBwKgghMm
// SIG // MIITIgIBAzEPMA0GCWCGSAFlAwQCAQUAMIIBPQYLKoZI
// SIG // hvcNAQkQAQSgggEsBIIBKDCCASQCAQEGCisGAQQBhFkK
// SIG // AwEwMTANBglghkgBZQMEAgEFAAQgUxxvtzGbX9TOynkG
// SIG // adFIRPassAqsU/wpeOKYnKXKAFICBliLnQCoGhgTMjAx
// SIG // NzAyMDkwNDE5MjAuMDk5WjAHAgEBgAIB9KCBuaSBtjCB
// SIG // szELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9Q
// SIG // UjEnMCUGA1UECxMebkNpcGhlciBEU0UgRVNOOjcyOEQt
// SIG // QzQ1Ri1GOUVCMSUwIwYDVQQDExxNaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBTZXJ2aWNloIIO0DCCBnEwggRZoAMCAQIC
// SIG // CmEJgSoAAAAAAAIwDQYJKoZIhvcNAQELBQAwgYgxCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xMjAwBgNVBAMTKU1pY3Jvc29m
// SIG // dCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eSAyMDEw
// SIG // MB4XDTEwMDcwMTIxMzY1NVoXDTI1MDcwMTIxNDY1NVow
// SIG // fDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAwggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCpHQ28dxGK
// SIG // OiDs/BOX9fp/aZRrdFQQ1aUKAIKF++18aEssX8XD5WHC
// SIG // drc+Zitb8BVTJwQxH0EbGpUdzgkTjnxhMFmxMEQP8WCI
// SIG // hFRDDNdNuDgIs0Ldk6zWczBXJoKjRQ3Q6vVHgc2/JGAy
// SIG // WGBG8lhHhjKEHnRhZ5FfgVSxz5NMksHEpl3RYRNuKMYa
// SIG // +YaAu99h/EbBJx0kZxJyGiGKr0tkiVBisV39dx898Fd1
// SIG // rL2KQk1AUdEPnAY+Z3/1ZsADlkR+79BL/W7lmsqxqPJ6
// SIG // Kgox8NpOBpG2iAg16HgcsOmZzTznL0S6p/TcZL2kAcEg
// SIG // CZN4zfy8wMlEXV4WnAEFTyJNAgMBAAGjggHmMIIB4jAQ
// SIG // BgkrBgEEAYI3FQEEAwIBADAdBgNVHQ4EFgQU1WM6XIox
// SIG // kPNDe3xGG8UzaFqFbVUwGQYJKwYBBAGCNxQCBAweCgBT
// SIG // AHUAYgBDAEEwCwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQF
// SIG // MAMBAf8wHwYDVR0jBBgwFoAU1fZWy4/oolxiaNE9lJBb
// SIG // 186aGMQwVgYDVR0fBE8wTTBLoEmgR4ZFaHR0cDovL2Ny
// SIG // bC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMv
// SIG // TWljUm9vQ2VyQXV0XzIwMTAtMDYtMjMuY3JsMFoGCCsG
// SIG // AQUFBwEBBE4wTDBKBggrBgEFBQcwAoY+aHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNSb29D
// SIG // ZXJBdXRfMjAxMC0wNi0yMy5jcnQwgaAGA1UdIAEB/wSB
// SIG // lTCBkjCBjwYJKwYBBAGCNy4DMIGBMD0GCCsGAQUFBwIB
// SIG // FjFodHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vUEtJL2Rv
// SIG // Y3MvQ1BTL2RlZmF1bHQuaHRtMEAGCCsGAQUFBwICMDQe
// SIG // MiAdAEwAZQBnAGEAbABfAFAAbwBsAGkAYwB5AF8AUwB0
// SIG // AGEAdABlAG0AZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUA
// SIG // A4ICAQAH5ohRDeLG4Jg/gXEDPZ2joSFvs+umzPUxvs8F
// SIG // 4qn++ldtGTCzwsVmyWrf9efweL3HqJ4l4/m87WtUVwgr
// SIG // UYJEEvu5U4zM9GASinbMQEBBm9xcF/9c+V4XNZgkVkt0
// SIG // 70IQyK+/f8Z/8jd9Wj8c8pl5SpFSAK84Dxf1L3mBZdmp
// SIG // tWvkx872ynoAb0swRCQiPM/tA6WWj1kpvLb9BOFwnzJK
// SIG // J/1Vry/+tuWOM7tiX5rbV0Dp8c6ZZpCM/2pif93FSguR
// SIG // JuI57BlKcWOdeyFtw5yjojz6f32WapB4pm3S4Zz5Hfw4
// SIG // 2JT0xqUKloakvZ4argRCg7i1gJsiOCC1JeVk7Pf0v35j
// SIG // WSUPei45V3aicaoGig+JFrphpxHLmtgOR5qAxdDNp9Dv
// SIG // fYPw4TtxCd9ddJgiCGHasFAeb73x4QDf5zEHpJM692VH
// SIG // eOj4qEir995yfmFrb3epgcunCaw5u+zGy9iCtHLNHfS4
// SIG // hQEegPsbiSpUObJb2sgNVZl6h3M7COaYLeqN4DMuEin1
// SIG // wC9UJyH3yKxO2ii4sanblrKnQqLJzxlBTeCG+SqaoxFm
// SIG // MNO7dDJL32N79ZmKLxvHIa9Zta7cRDyXUHHXodLFVeNp
// SIG // 3lfB0d4wwP3M5k37Db9dT+mdHhk4L7zPWAUu7w2gUDXa
// SIG // 7wknHNWzfjUeCLraNtvTX4/edIhJEjCCBNowggPCoAMC
// SIG // AQICEzMAAACyNQVoNyIcDacAAAAAALIwDQYJKoZIhvcN
// SIG // AQELBQAwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UE
// SIG // AxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAw
// SIG // HhcNMTYwOTA3MTc1NjU3WhcNMTgwOTA3MTc1NjU3WjCB
// SIG // szELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9Q
// SIG // UjEnMCUGA1UECxMebkNpcGhlciBEU0UgRVNOOjcyOEQt
// SIG // QzQ1Ri1GOUVCMSUwIwYDVQQDExxNaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBTZXJ2aWNlMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAmEoBu9FY9X90kULpoS5TXfIs
// SIG // IG8SLpvT15WV3J1viXwOa3ApTbAuDzVW9o8CS/h8VW1Q
// SIG // zT/HqnjyEAeoB2sDu/wr8Kolnd388WNwJGVvhPpLRF7O
// SIG // cih9wrMfxW+GapmHrrr+zAWYvm++FYJHZbcvdcq82hB6
// SIG // mzsyT9odSJIOIuexsUJtWcJiniwqCvA1NyACCezhFOO1
// SIG // F+OAflTuXVEOk9maSjPJryYN6/ZrI5UvP10SITdKJM+O
// SIG // vQ+bUz/u6e6McHvaO/VquZk8t9sBfBLLP1XO9K/WBrk6
// SIG // PN98J9RylM2vSgk2xiLsXXO9OuKAGh31vXdwjWNwe8DA
// SIG // 9u6eNGmHtwIDAQABo4IBGzCCARcwHQYDVR0OBBYEFDNk
// SIG // vmdrHNz5Y0QGSOTFQ8mQ9oKVMB8GA1UdIwQYMBaAFNVj
// SIG // OlyKMZDzQ3t8RhvFM2hahW1VMFYGA1UdHwRPME0wS6BJ
// SIG // oEeGRWh0dHA6Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kv
// SIG // Y3JsL3Byb2R1Y3RzL01pY1RpbVN0YVBDQV8yMDEwLTA3
// SIG // LTAxLmNybDBaBggrBgEFBQcBAQROMEwwSgYIKwYBBQUH
// SIG // MAKGPmh0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2kv
// SIG // Y2VydHMvTWljVGltU3RhUENBXzIwMTAtMDctMDEuY3J0
// SIG // MAwGA1UdEwEB/wQCMAAwEwYDVR0lBAwwCgYIKwYBBQUH
// SIG // AwgwDQYJKoZIhvcNAQELBQADggEBAEHgsqCgyvQob8yN
// SIG // 3f7bvSBViWwgKXZ2P9QnyV57g/vBwkc2jfZ6IUxEGzpx
// SIG // Y6sjJr9ErqIZ7yfWWIa6enD6L7RL5HFIOlfStf+jEBua
// SIG // CcNfHgnoMM2R61RcwQtZ/vTqUi+oejVrYLaDOAmmmnbb
// SIG // lrPXNYeoZDpcBs9MEw3GIhi3AGOMuHWxReGpR1rb//y7
// SIG // Gh1UOdsVX+ZX5DSeeC/9tNwg39ITEKPOPXHZ4bBeZVl7
// SIG // jmzulbOZ3/CoHGEPTE9XqtbEMfZ8DWLrbGsAoQqE0nxx
// SIG // KScipNgTD8B6yJ3dOjnq3icG3ARhjjxqhJrfTraa7bBM
// SIG // 4fpRjYBCBaYm9oNvAeahggN5MIICYQIBATCB46GBuaSB
// SIG // tjCBszELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hp
// SIG // bmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoT
// SIG // FU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxME
// SIG // TU9QUjEnMCUGA1UECxMebkNpcGhlciBEU0UgRVNOOjcy
// SIG // OEQtQzQ1Ri1GOUVCMSUwIwYDVQQDExxNaWNyb3NvZnQg
// SIG // VGltZS1TdGFtcCBTZXJ2aWNloiUKAQEwCQYFKw4DAhoF
// SIG // AAMVAL3/xZVjkPETnGDWGcCv6bieHiAdoIHCMIG/pIG8
// SIG // MIG5MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRN
// SIG // T1BSMScwJQYDVQQLEx5uQ2lwaGVyIE5UUyBFU046NERF
// SIG // OS0wQzVFLTNFMDkxKzApBgNVBAMTIk1pY3Jvc29mdCBU
// SIG // aW1lIFNvdXJjZSBNYXN0ZXIgQ2xvY2swDQYJKoZIhvcN
// SIG // AQEFBQACBQDcRcxhMCIYDzIwMTcwMjA4MTY1NzA1WhgP
// SIG // MjAxNzAyMDkxNjU3MDVaMHcwPQYKKwYBBAGEWQoEATEv
// SIG // MC0wCgIFANxFzGECAQAwCgIBAAICFkQCAf8wBwIBAAIC
// SIG // HNYwCgIFANxHHeECAQAwNgYKKwYBBAGEWQoEAjEoMCYw
// SIG // DAYKKwYBBAGEWQoDAaAKMAgCAQACAxbjYKEKMAgCAQAC
// SIG // AwehIDANBgkqhkiG9w0BAQUFAAOCAQEAmtk+iZ29SCgi
// SIG // /zl0APWo9nKh8oSoyCiZT01PB1aGJLqG2fEpZYGBMMsF
// SIG // CRHRFG25zCeE4MmQZXMAd5KSZR+1pO7UXFd1Lk3UalKq
// SIG // pWos+LF2xXYPToI0URyDInVPHzpVlFNUp92iHgxs7Dmi
// SIG // oAOKBZD9wT54tlMcuhSnTUkJIuYlIZ6Hp0kSkbMjNc8h
// SIG // OFRa46hMf6Okqeno9HtvUjF7ti+9dl8FPyAy/K7KXE7M
// SIG // J9TMSYduqyrQzOxu8EjYwl2eASWUh6KdBQ49OO25Xs36
// SIG // u8E9ZwICSY8qwPVLEu0r7UDNPRJXqarQsBHV8WGobq4N
// SIG // nVWznaVKbjVKf5xiXhSiLDGCAvUwggLxAgEBMIGTMHwx
// SIG // CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9u
// SIG // MRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jv
// SIG // c29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwAhMzAAAAsjUF
// SIG // aDciHA2nAAAAAACyMA0GCWCGSAFlAwQCAQUAoIIBMjAa
// SIG // BgkqhkiG9w0BCQMxDQYLKoZIhvcNAQkQAQQwLwYJKoZI
// SIG // hvcNAQkEMSIEIPhUXLWXr6YKBiT7uPo2+l8wbiwgWCIj
// SIG // DRB/HBNzLOIhMIHiBgsqhkiG9w0BCRACDDGB0jCBzzCB
// SIG // zDCBsQQUvf/FlWOQ8ROcYNYZwK/puJ4eIB0wgZgwgYCk
// SIG // fjB8MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1N
// SIG // aWNyb3NvZnQgVGltZS1TdGFtcCBQQ0EgMjAxMAITMwAA
// SIG // ALI1BWg3IhwNpwAAAAAAsjAWBBRbjLJUoq+Iepxcv7E9
// SIG // At7AIY9dqDANBgkqhkiG9w0BAQsFAASCAQB/PZV1EI6N
// SIG // fPWQ4Ak4WmbEMpTZWsUtAJRPvGwh7EP6p5jrkOYj27ws
// SIG // RZNy83K+VtdP4aHWN78BpgR8YeLXc4sh0WH5541SrF8T
// SIG // 0FVpiLHOwcdUMvNUX5ivZALygMXPTbfnWnvWeUZ+ekMk
// SIG // CJPJj/5iAsXeqIg1P9J29mddXCNMKxqYOIAFr5tO4ELz
// SIG // 4CKik7Xc1Nk/oOhYJKupcI76dsUaZ3zApsWFY2SD9vI1
// SIG // CldXytG75dRpfoo/b8STSKDnCSIcTwPjQT9rJdVp0DfE
// SIG // TwKBZpQtkLR/vbrhDr8VubvGiGVTWOlBkk4oFFlnkm0x
// SIG // srsjywLtfjMN3hDMMTce4oBb
// SIG // End signature block
